// Quick random noise function I found at http://obge.paradice-insight.us/wiki/Includes_%28Effects%29
// Generates white noise
float Random(in float2 uv)
{
    float2 noise = (frac(sin(dot(uv ,float2(12.9898,78.233)*2.0)) * 43758.5453));
    return abs(noise.x + noise.y) * 0.5;
}

float4 Noise(float2 texCoords) {
	float2 rOffset = Time * GrainSpeed * float2(1, 0);
	float2 gOffset = Time * GrainSpeed * float2(0, 1);
	float2 bOffset = Time * GrainSpeed * float2(1, 1);
	float noiseR = Random(texCoords + rOffset);
	float noiseG = Random(texCoords + gOffset);
	float noiseB = Random(texCoords + bOffset);

	float4 noise = float4(noiseR, noiseG, noiseB, 1) - 0.5;
	noise *= NoiseStrength;
	noise.a = 1;
	return noise;
}